/* FCD Header Infomation                                          */
/* Thanks: This info was based by Noia & vondu's Report.          */

#ifndef FCD_HEAD_H
#define FCD_HEAD_H

#include <stdio.h> /* FILE     */
#include "fcd_basic.h"

#ifdef  __cplusplus
extern "C" {
#endif

#define SIG_MAX     12
#define SIGNATURE   "FCD V1.0"

#define FBH_SIZE    0x9C
#define STEH_OFSET  FBH_SIZE
#define STEH_SIZE  (0x200  - STEH_OFSET)
#define STEH_RSIZE (STEH_SIZE - 11)
#define MTEH_OFSET  FBH_SIZE
#define MTEH_SIZE  (0x2776 - MTEH_OFSET)
#define REH_OFSET   0x200
#define REH_SIZE   (0x524  - REH_OFSET )

typedef struct {
	short fcd_type;  /* 0: V-ISO, 
	                    1: V-ISO Compress, 
	                    2: R-ISO, 
	                    3: R-ISO Compress, 
	                    5: Multi Track, 
	                    6: V-ISO Hi-Compress, 
	                    8: R-ISO Hi-Compress              */
	short orig_type; /* 0: ISO9660 Only,
	                    1: MIX MODE,
	                    2: AUDIO DISC,
	                    5: XA (With DA)
	                    6: XA (DATA Only)                 */
	int   trk_offset;/* 0x00008000, 0x00009300            */
	int   fcd_size;
	char  desc[DESC_MAX];
	char  sig[SIG_MAX];
	LBN   data_track_start;
} basic_fcd_header;  /* Common for all FCD File           */

typedef struct {
	MSF  start;
	char type;      /* 0x41 DATA,
	                   0x01 DA,
	                   0x00 Empty                         */
}fcd_track_table;

typedef struct {
	LBN  start;
	LBN  end;

	char type;       /* 00: V-ISO Uncompress,
	                    01: V-ISO Compress,
	                    02: DA,
	                    03: XA Uncompress,
	                    05: V-ISO Hi-Compress             */

	char filename[FNAME_MAX];

	int data_offset; /* =le_char_array_to_int32(filename);*/
}fcd_track_infomation;

typedef struct {
	char  track[2];
	/******************************************************
	         Fuuucking FCD Spec Infomation!!!!!
	 
		if (track[0] > track[1]){
			data_track = track[0];
			last_audio_track = track[1];
		}else{
			first_track = track[0];
			last_track = track[1];
		}

		Consistancy  - BAD.
		Need         - NOTING.
		Efficiency   - BAD.
	 ******************************************************/
	MSF   total;     /* session 1 total MSF data          */

	fcd_track_table      tt[TRACK_MAX];
	fcd_track_infomation ti[TRACK_MAX];
} multi_track_extantion_header;

typedef struct{
	char  first;     /* first track index = 0x01          */
	char  last;      /* last track index  = 0x01          */
	LBN   total;     /* DATA track LBN                    */

	fcd_track_table t1;

	char reserve[STEH_RSIZE];
} singl_track_extantion_header;

typedef struct{
    char reserve[REH_SIZE];
} recordable_extantion_header;

#ifndef FCD_HEAD_C
extern basic_fcd_header *get_basic_header(FILE *stream);
extern singl_track_extantion_header *get_ste_header(FILE *stream);
extern multi_track_extantion_header *get_mte_header(FILE *stream);
extern recordable_extantion_header *get_re_header(FILE *stream);
extern int write_basic_header(basic_fcd_header *bfh, FILE *stream);
extern int write_mte_header(multi_track_extantion_header *mteh, FILE *stream);
#endif /* FCD_HEAD_C */

#ifdef  __cplusplus
}
#endif

#endif /* FCD_HEAD_H */
